#version 330 core
layout(std140, binding = 0) uniform MeshState {
    int RenderFlag;
    float Alpha;
    float BlendMeshTexCoordU;
    float BlendMeshTexCoordV;
    float BlendMeshLight;
};

layout (location = 0) in vec3 aPosition;
layout (location = 1) in vec2 aTexCoord;

uniform mat4 projection;
uniform mat4 view;
uniform mat4 model;

out vec2 TexCoord;
out vec4 LightEffect;

void main() {
    gl_Position = projection * view * model * vec4(aPosition, 1.0);
    TexCoord = aTexCoord;
	if (RenderFlag == 1) {  // RENDER_TEXTURE
        TexCoord.x += BlendMeshTexCoordU;
        TexCoord.y += BlendMeshTexCoordV;
    }
	LightEffect = vec4(1.0);
}
