#version 330 core

in vec2 TexCoord;
in vec4 vColor;

uniform sampler2D texture1;

out vec4 FragColor;

void main()
{
    vec4 texColor = texture(texture1, TexCoord);
    vec4 vLightColor = vColor;

    float maxIntensity = 1.0;
    vLightColor.rgb = min(vLightColor.rgb, vec3(maxIntensity));

    FragColor = texColor * vLightColor;
}
